//Read file
val file = sc.textFile("/opt/spark-data/testword2")
//Store all words as an array
val flatfile = file.flatMap(line => line.split(" "))
flatfile.collect()
//Map each word to 1
val mapping = flatfile.map(word => (word, 1))
mapping.collect()
//Reduce by Key (sum all values by key)
val result = mapping.reduceByKey((a,b)=>a+b)
result.collect()
//Save as text file
result.saveAsTextFile("/opt/spark-data/word-count-result2")